/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api.renderer;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.renderer.ModPreviewRenderer;
import com.misterpemodder.shulkerboxtooltip.impl.renderer.VanillaPreviewRenderer;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

@Environment(value=EnvType.CLIENT)
public interface PreviewRenderer {
    @Nonnull
    public static PreviewRenderer getDefaultRendererInstance() {
        return ShulkerBoxTooltip.config.preview.theme == Configuration.Theme.VANILLA ? PreviewRenderer.getVanillaRendererInstance() : PreviewRenderer.getModRendererInstance();
    }

    @Nonnull
    public static PreviewRenderer getModRendererInstance() {
        return ModPreviewRenderer.INSTANCE;
    }

    @Nonnull
    public static PreviewRenderer getVanillaRendererInstance() {
        return VanillaPreviewRenderer.INSTANCE;
    }

    public int getHeight();

    public int getWidth();

    public void setPreview(PreviewContext var1, PreviewProvider var2);

    public void setPreviewType(PreviewType var1);

    @Deprecated(forRemoval=true, since="5.2.0")
    default public void draw(int x, int y, GuiGraphics graphics, Font font, int mouseX, int mouseY) {
        throw new UnsupportedOperationException("Method not implemented");
    }

    default public void draw(int x, int y, int viewportWidth, int viewportHeight, GuiGraphics graphics, Font font, int mouseX, int mouseY) {
        this.draw(x, y, graphics, font, mouseX, mouseY);
    }
}

