/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.config.ClientConfiguration;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.network.ClientNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class ShulkerBoxTooltipClient {
    private static ItemStack previousStack = null;
    public static Minecraft client;
    private static boolean wasPreviewAccessed;
    private static boolean previewKeyPressed;
    private static boolean fullPreviewKeyPressed;
    private static boolean lockPreviewKeyPressed;
    private static boolean lockKeyHintsEnabled;

    public static void init() {
        client = Minecraft.getInstance();
        ClientNetworking.init();
    }

    public static ClientConfiguration getConfig() {
        return (ClientConfiguration)ShulkerBoxTooltip.config;
    }

    private static boolean isPreviewRequested() {
        return ShulkerBoxTooltipClient.getConfig().preview.alwaysOn || ShulkerBoxTooltipClient.isPreviewKeyPressed();
    }

    private static List<Component> getTooltipHints(PreviewContext context, PreviewProvider provider) {
        if (!ShulkerBoxTooltipClient.getConfig().preview.enable || !provider.shouldDisplay(context)) {
            return Collections.emptyList();
        }
        boolean previewRequested = ShulkerBoxTooltipClient.isPreviewRequested();
        ArrayList<Component> hints = new ArrayList<Component>();
        Component previewKeyHint = ShulkerBoxTooltipClient.getPreviewKeyTooltipHint(context, provider, previewRequested);
        Component lockKeyHint = ShulkerBoxTooltipClient.getLockKeyTooltipHint(context, provider, previewRequested);
        if (previewKeyHint != null) {
            hints.add(previewKeyHint);
        }
        if (lockKeyHint != null) {
            hints.add(lockKeyHint);
        }
        return hints;
    }

    @Nullable
    private static Component getPreviewKeyTooltipHint(PreviewContext context, PreviewProvider provider, boolean previewRequested) {
        if (previewRequested && ShulkerBoxTooltipClient.isFullPreviewKeyPressed()) {
            return null;
        }
        boolean fullPreviewAvailable = provider.isFullPreviewAvailable(context);
        if (!fullPreviewAvailable && previewRequested) {
            return null;
        }
        MutableComponent previewKeyHint = Component.literal((String)"");
        Component previewKeyText = ShulkerBoxTooltipClient.getConfig().controls.previewKey.get().getDisplayName();
        if (previewRequested) {
            previewKeyHint.append(ShulkerBoxTooltipClient.getConfig().controls.fullPreviewKey.get().getDisplayName());
            if (!ShulkerBoxTooltipClient.getConfig().preview.alwaysOn) {
                previewKeyHint.append("+").append(previewKeyText);
            }
        } else {
            previewKeyHint.append(previewKeyText);
        }
        previewKeyHint.append(": ");
        previewKeyHint.withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD));
        String contentHint = ShulkerBoxTooltipApi.getCurrentPreviewType(fullPreviewAvailable) == PreviewType.NO_PREVIEW ? (ShulkerBoxTooltipClient.getConfig().preview.swapModes ? provider.getFullTooltipHintLangKey(context) : provider.getTooltipHintLangKey(context)) : (ShulkerBoxTooltipClient.getConfig().preview.swapModes ? provider.getTooltipHintLangKey(context) : provider.getFullTooltipHintLangKey(context));
        return previewKeyHint.append((Component)Component.translatable((String)contentHint).setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE)));
    }

    @Nullable
    private static Component getLockKeyTooltipHint(PreviewContext context, PreviewProvider provider, boolean previewRequested) {
        if (!previewRequested || ShulkerBoxTooltipClient.isLockPreviewKeyPressed() || !lockKeyHintsEnabled) {
            return null;
        }
        MutableComponent lockKeyHint = Component.literal((String)"");
        String lockKeyHintLangKey = provider.getLockKeyTooltipHintLangKey(context);
        lockKeyHint.append(ShulkerBoxTooltipClient.getConfig().controls.lockTooltipKey.get().getDisplayName());
        lockKeyHint.append(": ");
        lockKeyHint.withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD));
        lockKeyHint.append((Component)Component.translatable((String)lockKeyHintLangKey).setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE)));
        return lockKeyHint;
    }

    public static void modifyStackTooltip(ItemStack stack, Consumer<Collection<Component>> tooltip) {
        if (client == null) {
            return;
        }
        PreviewContext context = PreviewContext.builder(stack).withOwner((Player)ShulkerBoxTooltipClient.client.player).build();
        TooltipDisplay tooltipDisplay = (TooltipDisplay)stack.getComponents().get(DataComponents.TOOLTIP_DISPLAY);
        PreviewProvider provider = ShulkerBoxTooltipApi.getPreviewProviderForStackWithOverrides(stack);
        if (provider == null || tooltipDisplay != null && tooltipDisplay.hideTooltip()) {
            return;
        }
        if (previousStack == null || !ItemStack.matches((ItemStack)stack, (ItemStack)previousStack)) {
            wasPreviewAccessed = false;
        }
        previousStack = stack;
        if (!wasPreviewAccessed) {
            provider.onInventoryAccessStart(context);
        }
        wasPreviewAccessed = true;
        if (provider.showTooltipHints(context)) {
            if (ShulkerBoxTooltipClient.getConfig().tooltip.type == Configuration.ShulkerBoxTooltipType.MOD) {
                tooltip.accept(provider.addTooltip(context));
            }
            if (ShulkerBoxTooltipClient.getConfig().tooltip.showKeyHints) {
                tooltip.accept(ShulkerBoxTooltipClient.getTooltipHints(context, provider));
            }
        }
    }

    public static boolean isPreviewAvailable(PreviewContext context) {
        if (ShulkerBoxTooltipClient.getConfig().preview.enable) {
            ItemStack stack = context.stack();
            TooltipDisplay tooltipDisplay = (TooltipDisplay)stack.getComponents().get(DataComponents.TOOLTIP_DISPLAY);
            if (tooltipDisplay != null && tooltipDisplay.hideTooltip()) {
                return false;
            }
            PreviewProvider provider = ShulkerBoxTooltipApi.getPreviewProviderForStackWithOverrides(context.stack());
            return provider != null && provider.shouldDisplay(context) && ShulkerBoxTooltipApi.getCurrentPreviewType(provider.isFullPreviewAvailable(context)) != PreviewType.NO_PREVIEW;
        }
        return false;
    }

    public static PreviewType getCurrentPreviewType(boolean hasFullPreviewMode) {
        boolean previewRequested = ShulkerBoxTooltipClient.isPreviewRequested();
        if (previewRequested && !hasFullPreviewMode) {
            return PreviewType.COMPACT;
        }
        if (ShulkerBoxTooltipClient.getConfig().preview.swapModes) {
            if (previewRequested) {
                return ShulkerBoxTooltipClient.isFullPreviewKeyPressed() ? PreviewType.COMPACT : PreviewType.FULL;
            }
        } else if (previewRequested) {
            return ShulkerBoxTooltipClient.isFullPreviewKeyPressed() ? PreviewType.FULL : PreviewType.COMPACT;
        }
        return PreviewType.NO_PREVIEW;
    }

    public static boolean isPreviewKeyPressed() {
        return previewKeyPressed;
    }

    public static boolean isFullPreviewKeyPressed() {
        return fullPreviewKeyPressed;
    }

    public static boolean isLockPreviewKeyPressed() {
        return lockPreviewKeyPressed;
    }

    public static void setLockKeyHintsEnabled(boolean value) {
        lockKeyHintsEnabled = value;
    }

    private static boolean isKeyPressed(@Nullable Key key) {
        if (key == null || key.equals(Key.UNKNOWN_KEY) || key.isUnbound()) {
            return false;
        }
        return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)key.get().getValue());
    }

    public static void updatePreviewKeys() {
        if (ShulkerBoxTooltipClient.getConfig() == null) {
            previewKeyPressed = false;
            fullPreviewKeyPressed = false;
            lockPreviewKeyPressed = false;
        } else {
            previewKeyPressed = ShulkerBoxTooltipClient.isKeyPressed(ShulkerBoxTooltipClient.getConfig().controls.previewKey);
            fullPreviewKeyPressed = ShulkerBoxTooltipClient.isKeyPressed(ShulkerBoxTooltipClient.getConfig().controls.fullPreviewKey);
            lockPreviewKeyPressed = ShulkerBoxTooltipClient.isKeyPressed(ShulkerBoxTooltipClient.getConfig().controls.lockTooltipKey);
        }
    }

    static {
        wasPreviewAccessed = false;
        previewKeyPressed = false;
        fullPreviewKeyPressed = false;
        lockPreviewKeyPressed = false;
        lockKeyHintsEnabled = false;
    }
}

