/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry;

import com.misterpemodder.shulkerboxtooltip.impl.config.gui.ConfigCategoryTab;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.ValueConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.tree.ValueConfigNode;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

@Environment(value=EnvType.CLIENT)
public final class BooleanValueConfigEntry<C>
extends ValueConfigEntry<C, Boolean, Boolean> {
    private final CycleButton<Boolean> valueButton;

    public BooleanValueConfigEntry(ConfigCategoryTab<C> tab, ValueConfigNode<C, Boolean, Boolean> valueNode) {
        super(tab, valueNode);
        this.valueButton = CycleButton.booleanBuilder((Component)CommonComponents.GUI_YES.copy().withStyle(ChatFormatting.GREEN), (Component)CommonComponents.GUI_NO.copy().withStyle(ChatFormatting.RED)).withInitialValue((Object)((Boolean)this.getValue())).displayOnlyValue().create(0, 0, 160, 20, valueNode.getTitle(), (b, value) -> this.setValue(value));
        this.children.addFirst(this.valueButton);
    }

    @Override
    public void refresh() {
        super.refresh();
        Boolean value = (Boolean)this.getValue();
        if (!Objects.equals(this.valueButton.getValue(), value)) {
            this.valueButton.setValue((Object)value);
        }
    }

    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float delta) {
        int x = this.getContentX();
        int y = this.getContentY();
        this.renderLabel(guiGraphics);
        this.valueButton.setWidth(160 - this.resetButton.getWidth() - 2 - this.undoButton.getWidth() - 2);
        if (this.tab.getMinecraft().font.isBidirectional()) {
            this.undoButton.setX(x);
            this.undoButton.setY(y);
            this.resetButton.setX(x + this.undoButton.getWidth() + 2);
            this.resetButton.setY(y);
            this.valueButton.setX(x + this.undoButton.getWidth() + 2 + this.resetButton.getWidth() + 2);
            this.valueButton.setY(y);
        } else {
            this.undoButton.setX(this.getContentRight() - this.undoButton.getWidth());
            this.undoButton.setY(y);
            this.resetButton.setX(this.undoButton.getX() - this.resetButton.getWidth() - 2);
            this.resetButton.setY(y);
            this.valueButton.setX(this.resetButton.getX() - this.valueButton.getWidth() - 2);
            this.valueButton.setY(y);
        }
        this.valueButton.render(guiGraphics, mouseX, mouseY, delta);
        this.resetButton.render(guiGraphics, mouseX, mouseY, delta);
        this.undoButton.render(guiGraphics, mouseX, mouseY, delta);
    }
}

