/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry;

import com.misterpemodder.shulkerboxtooltip.impl.config.gui.ConfigCategoryTab;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.ConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.tree.ValueConfigNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class ValueConfigEntry<C, T, V>
extends ConfigEntry {
    private final Component label;
    private final Component labelChanged;
    private final Component labelError;
    private final Component labelErrorChanged;
    @Nullable
    private final List<FormattedCharSequence> tooltip;
    private List<FormattedCharSequence> tooltipWithError;
    protected final ConfigCategoryTab<C> tab;
    protected final List<AbstractWidget> children = Lists.newArrayList();
    protected final ValueConfigNode<C, T, V> valueNode;
    public final Button resetButton;
    public final Button undoButton;
    @Nullable
    private Component validationError;
    private boolean hasChanged;
    public static final Component RESET_BUTTON_LABEL = Component.translatable((String)"shulkerboxtooltip.config.reset_to_default.small");
    public static final Component RESET_BUTTON_TOOLTIP = Component.translatable((String)"shulkerboxtooltip.config.reset_to_default.full");
    public static final Component UNDO_BUTTON_LABEL = Component.translatable((String)"shulkerboxtooltip.config.undo.small");
    public static final Component UNDO_BUTTON_TOOLTIP = Component.translatable((String)"shulkerboxtooltip.config.undo.full");

    protected ValueConfigEntry(ConfigCategoryTab<C> tab, ValueConfigNode<C, T, V> valueNode) {
        this.tab = tab;
        this.label = valueNode.getTitle().copy().withStyle(ChatFormatting.GRAY);
        this.labelChanged = this.label.copy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.WHITE});
        this.labelError = this.label.copy().withStyle(ChatFormatting.RED);
        this.labelErrorChanged = this.label.copy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.RED});
        this.tooltip = valueNode.getTooltip() == null ? null : tab.getMinecraft().font.split((FormattedText)valueNode.getTooltip(), 350);
        this.tooltipWithError = this.getTooltipWithError();
        this.valueNode = valueNode;
        this.resetButton = Button.builder((Component)RESET_BUTTON_LABEL, b -> this.resetToDefault()).bounds(0, 0, Math.max(tab.getMinecraft().font.width((FormattedText)RESET_BUTTON_LABEL) + 6, 20), 20).build();
        this.resetButton.active = !valueNode.isDefaultValue(this.tab.getConfig());
        this.children.add((AbstractWidget)this.resetButton);
        this.undoButton = Button.builder((Component)UNDO_BUTTON_LABEL, b -> this.resetToActive()).bounds(0, 0, Math.max(tab.getMinecraft().font.width((FormattedText)UNDO_BUTTON_LABEL) + 6, 20), 20).build();
        this.undoButton.active = !valueNode.isActiveValue(this.tab.getConfig());
        this.children.add((AbstractWidget)this.undoButton);
    }

    public void resetToDefault() {
        this.valueNode.resetToDefault();
        this.tab.getScreen().refresh();
    }

    public void resetToActive() {
        this.valueNode.resetToActive(this.tab.getConfig());
        this.tab.getScreen().refresh();
    }

    public V getValue() {
        return this.valueNode.getEditingValue(this.tab.getConfig());
    }

    public void setValue(V value) {
        this.valueNode.setEditingValue(value);
        this.tab.getScreen().refresh();
    }

    @Override
    public void refresh() {
        this.resetButton.active = !this.valueNode.isDefaultValue(this.tab.getConfig());
        this.undoButton.active = !this.valueNode.isActiveValue(this.tab.getConfig());
        this.validationError = this.valueNode.validate(this.tab.getConfig());
        this.hasChanged = !this.valueNode.isActiveValue(this.tab.getConfig());
        this.tooltipWithError = this.getTooltipWithError();
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    @NotNull
    public List<? extends NarratableEntry> narratables() {
        return this.children;
    }

    @Override
    @Nullable
    public List<FormattedCharSequence> getTooltip() {
        return this.validationError != null ? this.tooltipWithError : this.tooltip;
    }

    private List<FormattedCharSequence> getTooltipWithError() {
        if (this.validationError != null) {
            ArrayList<FormattedCharSequence> errorTooltip = new ArrayList<FormattedCharSequence>();
            if (this.tooltip != null) {
                errorTooltip.addAll(this.tooltip);
            }
            errorTooltip.add(this.validationError.copy().withStyle(ChatFormatting.RED).getVisualOrderText());
            return errorTooltip;
        }
        return this.tooltip;
    }

    protected void renderLabel(GuiGraphics guiGraphics, int x, int y, int entryWidth) {
        Component l;
        if (this.validationError != null) {
            l = this.hasChanged ? this.labelErrorChanged : this.labelError;
        } else {
            Component component = l = this.hasChanged ? this.labelChanged : this.label;
        }
        if (this.tab.getMinecraft().font.isBidirectional()) {
            x = x + entryWidth - this.tab.getMinecraft().font.width((FormattedText)l);
        }
        guiGraphics.drawString(this.tab.getMinecraft().font, l.getVisualOrderText(), x, y + 5, -1, false);
    }
}

