/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config.gui;

import com.misterpemodder.shulkerboxtooltip.impl.config.gui.ConfigCategoryTab;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.ConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.ValueConfigEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ConfigEntryList
extends ContainerObjectSelectionList<ConfigEntry> {
    private final ConfigCategoryTab<?> tab;

    public ConfigEntryList(ConfigCategoryTab<?> tab, Minecraft minecraft, int width, int contentHeight, int headerHeight, int itemSpacing, Iterable<ConfigEntry> entries) {
        super(minecraft, width, contentHeight, headerHeight, itemSpacing);
        this.tab = tab;
        entries.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.renderWidget(guiGraphics, mouseX, mouseY, delta);
        ConfigEntry entry = (ConfigEntry)this.getHovered();
        if (entry != null) {
            if (entry instanceof ValueConfigEntry) {
                ValueConfigEntry valueEntry = (ValueConfigEntry)entry;
                if (valueEntry.resetButton.isHovered()) {
                    guiGraphics.setTooltipForNextFrame(ValueConfigEntry.RESET_BUTTON_TOOLTIP, mouseX, mouseY);
                    return;
                }
                if (valueEntry.undoButton.isHovered()) {
                    guiGraphics.setTooltipForNextFrame(ValueConfigEntry.UNDO_BUTTON_TOOLTIP, mouseX, mouseY);
                    return;
                }
            }
            if (entry.getTooltip() != null) {
                guiGraphics.setTooltipForNextFrame(entry.getTooltip(), mouseX, mouseY);
            }
        }
    }

    public int getRowWidth() {
        return this.width - 80;
    }

    public void refreshEntries() {
        this.children().forEach(ConfigEntry::refresh);
    }

    protected void renderListSeparators(GuiGraphics guiGraphics) {
    }
}

