/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry;

import com.misterpemodder.shulkerboxtooltip.impl.config.gui.ConfigCategoryTab;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.ConfigEntry;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class CategoryTitleConfigEntry
extends ConfigEntry {
    private final Minecraft minecraft;
    private final Component label;

    public CategoryTitleConfigEntry(ConfigCategoryTab<?> tab, Component label) {
        this.minecraft = tab.getMinecraft();
        this.label = label;
    }

    @NotNull
    public List<? extends NarratableEntry> narratables() {
        return List.of(new NarratableEntry(){

            @NotNull
            public NarratableEntry.NarrationPriority narrationPriority() {
                return NarratableEntry.NarrationPriority.HOVERED;
            }

            public void updateNarration(NarrationElementOutput narrationElementOutput) {
                narrationElementOutput.add(NarratedElementType.TITLE, CategoryTitleConfigEntry.this.label);
            }
        });
    }

    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float delta) {
        guiGraphics.drawCenteredString(this.minecraft.font, this.label, this.getContentXMiddle(), this.getContentY() + 5, -1);
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return List.of();
    }
}

