/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.util;

import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.util.ClientEnvironmentUtil;
import com.misterpemodder.shulkerboxtooltip.impl.util.ServerEnvironmentUtil;
import com.misterpemodder.shulkerboxtooltip.impl.util.forge.EnvironmentUtilImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract sealed class EnvironmentUtil
permits ClientEnvironmentUtil, ServerEnvironmentUtil {
    private static EnvironmentUtil instance;
    private static final String PACKAGE_NAME;
    private static final String CLIENT_ENVIRONMENT_UTIL;
    private static final String SERVER_ENVIRONMENT_UTIL;

    public static EnvironmentUtil getInstance() {
        if (instance == null) {
            String className = EnvironmentUtil.isClient() ? CLIENT_ENVIRONMENT_UTIL : SERVER_ENVIRONMENT_UTIL;
            try {
                Class<?> clazz = Class.forName(className);
                instance = (EnvironmentUtil)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        return instance;
    }

    @NotNull
    public abstract Configuration makeConfiguration();

    @NotNull
    public abstract Class<? extends Configuration> getConfigurationClass();

    @ExpectPlatform
    @Contract(value="-> _", pure=true)
    @ExpectPlatform.Transformed
    public static boolean isClient() {
        return EnvironmentUtilImpl.isClient();
    }

    static {
        PACKAGE_NAME = EnvironmentUtil.class.getPackageName();
        CLIENT_ENVIRONMENT_UTIL = PACKAGE_NAME + ".ClientEnvironmentUtil";
        SERVER_ENVIRONMENT_UTIL = PACKAGE_NAME + ".ServerEnvironmentUtil";
    }
}

