/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.util;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class Key {
    public static final Key UNKNOWN_KEY = new Key(InputConstants.UNKNOWN);
    InputConstants.Key inner;

    public Key(InputConstants.Key key) {
        this.inner = key;
    }

    public InputConstants.Key get() {
        return this.inner;
    }

    public boolean isUnbound() {
        return this.inner.equals((Object)InputConstants.UNKNOWN);
    }

    public void set(InputConstants.Key key) {
        this.inner = key;
    }

    @Nullable
    public static Key defaultPreviewKey() {
        return new Key(InputConstants.Type.KEYSYM.getOrCreate(340));
    }

    @Nullable
    public static Key defaultFullPreviewKey() {
        return new Key(InputConstants.Type.KEYSYM.getOrCreate(342));
    }

    @Nullable
    public static Key defaultLockTooltipKey() {
        return new Key(InputConstants.Type.KEYSYM.getOrCreate(341));
    }

    public static Key fromTranslationKey(@Nullable String translationKey) {
        if (translationKey == null) {
            return UNKNOWN_KEY;
        }
        try {
            return new Key(InputConstants.getKey((String)translationKey));
        }
        catch (Exception e) {
            return UNKNOWN_KEY;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        return Objects.equals(this.inner, key.inner);
    }

    public int hashCode() {
        return Objects.hashCode(this.inner);
    }
}

