/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network;

import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CEnderChestUpdate;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CMessages;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.inventory.PlayerEnderChestContainer;

public final class EnderChestInventoryListener
implements ContainerListener {
    private final ServerPlayer player;

    private EnderChestInventoryListener(ServerPlayer player) {
        this.player = player;
    }

    public void containerChanged(Container inv) {
        if (!ShulkerBoxTooltipApi.hasModAvailable(this.player)) {
            EnderChestInventoryListener.detachFrom(this.player);
            return;
        }
        S2CMessages.ENDER_CHEST_UPDATE.sendTo(this.player, S2CEnderChestUpdate.create((PlayerEnderChestContainer)inv, (HolderLookup.Provider)this.player.registryAccess()));
    }

    public static void attachTo(ServerPlayer player) {
        List listeners;
        PlayerEnderChestContainer inventory = player == null ? null : player.getEnderChestInventory();
        List list = listeners = inventory == null ? null : inventory.listeners;
        if (listeners != null) {
            for (ContainerListener listener : listeners) {
                if (!(listener instanceof EnderChestInventoryListener)) continue;
                return;
            }
        }
        if (inventory != null) {
            inventory.addListener((ContainerListener)new EnderChestInventoryListener(player));
        }
    }

    public static void detachFrom(ServerPlayer player) {
        List listeners;
        PlayerEnderChestContainer inventory = player == null ? null : player.getEnderChestInventory();
        List list = listeners = inventory == null ? null : inventory.listeners;
        if (listeners == null) {
            return;
        }
        for (ContainerListener listener : listeners) {
            if (!(listener instanceof EnderChestInventoryListener)) continue;
            inventory.removeListener(listener);
            return;
        }
    }
}

