/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.neoforge;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltipClient;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.config.ConfigurationHandler;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.ConfigScreen;
import com.misterpemodder.shulkerboxtooltip.impl.hook.GuiGraphicsExtensions;
import com.misterpemodder.shulkerboxtooltip.impl.tooltip.PreviewClientTooltipComponent;
import com.misterpemodder.shulkerboxtooltip.impl.tooltip.PreviewTooltipComponent;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT}, modid="shulkerboxtooltip")
public final class ShulkerBoxTooltipClientImpl
extends ShulkerBoxTooltipClient {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ShulkerBoxTooltipClient.init();
            ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parent) -> new ConfigScreen<Configuration>(parent, ShulkerBoxTooltip.configTree, ShulkerBoxTooltip.savedConfig, ConfigurationHandler::saveToFile));
        });
    }

    @SubscribeEvent
    public static void onRegisterTooltipComponentFactories(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(PreviewTooltipComponent.class, PreviewClientTooltipComponent::new);
    }

    @SubscribeEvent
    private static void onRenderTooltipTexture(RenderTooltipEvent.Texture event) {
        GuiGraphicsExtensions extendedGraphics = (GuiGraphicsExtensions)event.getGraphics();
        extendedGraphics.setTooltipTopYPosition(event.getY());
    }

    @SubscribeEvent
    private static void onGatherTooltipComponents(RenderTooltipEvent.GatherComponents event) {
        PreviewContext context = PreviewContext.builder(event.getItemStack()).withOwner((Player)(ShulkerBoxTooltipClient.client == null ? null : ShulkerBoxTooltipClient.client.player)).build();
        List elements = event.getTooltipElements();
        if (ShulkerBoxTooltipApi.isPreviewAvailable(context)) {
            PreviewTooltipComponent data = new PreviewTooltipComponent(ShulkerBoxTooltipApi.getPreviewProviderForStackWithOverrides(context.stack()), context);
            elements.add(1, Either.right((Object)data));
        }
        ShulkerBoxTooltipClient.modifyStackTooltip(context.stack(), toAdd -> toAdd.stream().map(Either::left).forEach(elements::add));
    }
}

